"use client"

import { ArrowRight } from "lucide-react"
import { flowSummary } from "@/lib/flowchart-data"

export function FlowSummary() {
  return (
    <div className="bg-card border border-border rounded-lg p-6">
      <h3 className="text-lg font-semibold text-foreground mb-4">One-Line Flow Summary</h3>
      <div className="flex flex-wrap items-center gap-2">
        {flowSummary.map((step, idx) => (
          <div key={idx} className="flex items-center gap-2">
            <span className="px-3 py-1.5 bg-secondary text-secondary-foreground text-sm font-medium rounded-full whitespace-nowrap">
              {step}
            </span>
            {idx < flowSummary.length - 1 && (
              <ArrowRight className="w-4 h-4 text-muted-foreground flex-shrink-0" />
            )}
          </div>
        ))}
      </div>
    </div>
  )
}
